#if NUNIT

#region References

using System;
using System.Collections;
using System.Text;

using NUnit.Framework;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.DAL.HL7AL;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;

using gov.va.med.vbecs.UnitTests;

#endregion

namespace gov.va.med.vbecs.DAL.HL7.UnitTests.OpenLibrary.Messages
{
	[TestFixture]
	public class Messages_HL7BtsMessage : BaseTest 
	{
		#region Variables & Setup

		private static string _hl7Message;

		HL7BtsMessage _btsMessage;

		static Messages_HL7BtsMessage()
		{
			_hl7Message = string.Concat(
				"MSH^~|\\&^WBC^500^VBECS^500^20080526151323^^BTS~O31^WBC200805261513234027^P^2.5^^^AL^AL^", 
				CARRIAGE_RETURN,
				"PID^^^212236^^AAHPHAANY~ILUUHAA~^^19561101^M^^^^^^^^^^^450207089^^^^^^^^^^^^^^^^^^^^", 
				CARRIAGE_RETURN,
				"PV1^^O^10W P-KC~~^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^",
				CARRIAGE_RETURN,
				"ORC^SC^22179268~OR^^^^^^^^^^53342~USER~THREE^^^^^^^^^^^^^",
				CARRIAGE_RETURN,
				"BPO^^~PLATELETS^^",
				CARRIAGE_RETURN,
				"BTX^^f33825f3-fdad-44f0-8b28-624819f14ae1^12000^~A POS^^^^^115^^TX^^20080519172625^USER,THREE^USER,ONE^20080519172524^20080519172625^~Yes^STOPPING, REACTION, Headache, Severe , Other interruption reason", 
				CARRIAGE_RETURN,
				"NTE^^^MAIN COMMENT HERE^RE", 
				CARRIAGE_RETURN,
				"NTE^^^Testing Purposes^VA-BCR",
				CARRIAGE_RETURN );
		}

		[SetUp]
		public void SetUp()
		{
			_btsMessage = new HL7BtsMessage( _hl7Message );
		}

		#endregion

		#region Constructors

		[Test]
		public void Ctor_Pass()
		{
			HL7BtsMessage btsMessage = new HL7BtsMessage( _hl7Message );
			//
			Assert.IsTrue( btsMessage != null );
		}

		[Test]
		[ExpectedException( typeof( ArgumentNullException ) )]
		public void Ctor_Fail()
		{
			HL7BtsMessage btsMessage = new HL7BtsMessage( null );
			//
			Assert.IsTrue( btsMessage != null );
		}

		#endregion

		#region Methods

		[Test]
		public void GetMessage_Pass()
		{
			Assert.IsNotNull( _btsMessage.GetMessage() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessage_Fail()
		{
		}

		[Test]
		public void GetMessageControlID_Pass()
		{
			Assert.IsNotNull( _btsMessage.GetMessageControlID() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessageControlID_Fail()
		{
		}

		[Test]
		public void GetMessageType_Pass()
		{
			Assert.IsNotNull( _btsMessage.GetMessageType() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessageType_Fail()
		{
		}

		[Test]
		public void IsResponseRequired_Pass()
		{
			Assert.IsTrue( _btsMessage.IsResponseRequired() == true );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsResponseRequired_Fail()
		{
		}

		#endregion

		#region Properties

		[Test]
		public void Delimiters_Pass()
		{
			Assert.IsNotNull( _btsMessage.Delimiters );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Delimiters_Fail()
		{
		}

		[Test]
		public void MessageType_Pass()
		{
			Assert.IsNotNull( _btsMessage.MessageType );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MessageType_Fail()
		{
		}

		[Test]
		public void TriggerEvent_Pass()
		{
			Assert.IsNotNull( _btsMessage.TriggerEvent );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void TriggerEvent_Fail()
		{
		}

		[Test]
		public void Message_Pass()
		{
			Assert.IsNotNull( _btsMessage.Message );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Message_Fail()
		{
		}

		[Test]
		public void MessageControlID_Pass()
		{
			Assert.IsNotNull( _btsMessage.MessageControlID );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MessageControlID_Fail()
		{
		}

		[Test]
		public void MSH_Pass()
		{
			Assert.IsNotNull( _btsMessage.MSH );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MSH_Fail()
		{
		}

		[Test]
		public void PID_Pass()
		{
			Assert.IsNotNull( _btsMessage.PID );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void PID_Fail()
		{
		}

		[Test]
		public void PV1_Pass()
		{
			Assert.IsNotNull( _btsMessage.PV1 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void PV1_Fail()
		{
		}

		[Test]
		public void ORC_Pass()
		{
			Assert.IsNotNull( _btsMessage.ORC );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ORC_Fail()
		{
		}

		[Test]
		public void BPO_Pass()
		{
			Assert.IsNotNull( _btsMessage.BPO );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void BPO_Fail()
		{
		}

		[Test]
		public void BTX_Pass()
		{
			Assert.IsNotNull( _btsMessage.BTX );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void BTX_Fail()
		{
		}

		[Test]
		public void NTE_Pass()
		{
			Assert.IsNotNull( _btsMessage.NTE );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void NTE_Fail()
		{
		}

		
		#endregion
	}
}
#endif